/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HerbalBrewsUtil {
    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block) {
        RegistrySupplier toReturn = HerbalBrewsUtil.registerWithoutItem(registerB, registrarB, name, block);
        HerbalBrewsUtil.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.m_135815_(), block) : registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.m_135815_(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static boolean matchesRecipe(Container inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        boolean matches;
        ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            validStacks.add(stackInSlot);
        }
        Iterator var10 = recipe.iterator();
        block1: do {
            if (!var10.hasNext()) {
                return true;
            }
            Ingredient entry = (Ingredient)var10.next();
            matches = false;
            for (ItemStack item : validStacks) {
                if (!entry.test(item)) continue;
                matches = true;
                validStacks.remove(item);
                continue block1;
            }
        } while (matches);
        return false;
    }
}

